using System;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;
using System.Windows.Forms;

namespace Sending_SMS_through_MS_SQL_Server
{
    class DatabaseHandling
    {
        private static SqlConnection sqlConn = null;
        private static string serverName = "(local)\\SQLExpress";
        private static string userName = "sqluser";
        private static string passwd = "abc123";
        private static string database = "ozekisms";
        private static string connectionString = "Server=" + serverName +";" +
                "Database=" + database + ";" +
                "User Id=" + userName + ";" +
                "Password=" + passwd + ";";

        private static void Connect(out string errorMsg)
        {
            errorMsg = "";

            if (sqlConn == null)
                sqlConn = new SqlConnection(connectionString);
            try
            {
                sqlConn.Open();
            }
            catch (Exception exc)
            {
                errorMsg = exc.Message;
            }
        }

        private static void CloseConnection()
        {
            try
            {
                sqlConn.Close();
            }
            catch (Exception)
            { }
        }

        public static void insertMessage(string receiver, string messageText, 
            out string errorMsg)
        {
            Connect(out errorMsg);
            if (errorMsg != "")
                return;

            try
            {
                SqlCommand sqlComm = sqlConn.CreateCommand();
                sqlComm.CommandText = "insert into ozekimessageout " + 
                    "(msgtype,receiver,msg,status) " +
                    "values ('SMS:TEXT','" + receiver + "','" + 
                    messageText + "','send');";
                if (sqlComm.ExecuteNonQuery() == 0)
                {
                    errorMsg = "Insert was UNsuccessful!";
                }
                else
                {
                    errorMsg = "Insert was successful!";
                }
            }
            catch (Exception e)
            {
                errorMsg = e.Message;
            }

            CloseConnection();
        }

        public static void updateListViewOut(ListView lvOut)
        {
            string errorMsg = "";
            Connect(out errorMsg);
            if (errorMsg != "")
                return;

            lvOut.Items.Clear();

            try
            {
                SqlCommand sqlComm = sqlConn.CreateCommand();
                sqlComm.CommandText = "select id,sender,receiver,msg,senttime," + 
                    "receivedtime,operator,msgtype,status from ozekimessageout;";

                SqlDataReader dr = sqlComm.ExecuteReader();
                if (dr != null)
                {
                    while (dr.Read())
                    {
                        string tmpStr = "";
                        tmpStr = (dr.IsDBNull(0)) ? ("") : (dr.GetInt32(0).ToString()); //id
                        ListViewItem lvi = new ListViewItem(tmpStr);
                        tmpStr = (dr.IsDBNull(1)) ? ("") : (dr.GetString(1)); //sender
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(2)) ? ("") : (dr.GetString(2)); //receiver
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(4)) ? ("") : (dr.GetString(4)); //senttime
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(5)) ? ("") : (dr.GetString(5)); //received time
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(6)) ? ("") : (dr.GetString(6)); //operator
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(8)) ? ("") : (dr.GetString(8)); //status
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(7)) ? ("") : (dr.GetString(7)); //msgtype
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(3)) ? ("") : (dr.GetString(3)); //msg
                        lvi.SubItems.Add(tmpStr);
                        lvOut.Items.Add(lvi);
                    }
                    dr.Close();
                }

                sqlConn.Close(); //we close the SQL connection
            }
            catch (Exception)
            {
                
            }

            CloseConnection();
        }

        public static void updateListViewIn(ListView lvIn)
        {
            string errorMsg = "";
            Connect(out errorMsg);
            if (errorMsg != "")
                return;

            lvIn.Items.Clear();

            try
            {
                SqlCommand sqlComm = sqlConn.CreateCommand();
                sqlComm.CommandText = "select id,sender,receiver,msg,senttime,receivedtime," +
                    "operator,msgtype from ozekimessagein;";

                SqlDataReader dr = sqlComm.ExecuteReader();
                if (dr != null)
                {
                    while (dr.Read())
                    {
                        string tmpStr = "";
                        tmpStr = (dr.IsDBNull(0)) ? ("") : (dr.GetInt32(0).ToString()); //id
                        ListViewItem lvi = new ListViewItem(tmpStr);
                        tmpStr = (dr.IsDBNull(1)) ? ("") : (dr.GetString(1)); //sender
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(2)) ? ("") : (dr.GetString(2)); //receiver
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(4)) ? ("") : (dr.GetString(4)); //senttime
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(5)) ? ("") : (dr.GetString(5)); //received time
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(6)) ? ("") : (dr.GetString(6)); //operator
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(7)) ? ("") : (dr.GetString(7)); //msgtype
                        lvi.SubItems.Add(tmpStr);
                        tmpStr = (dr.IsDBNull(3)) ? ("") : (dr.GetString(3)); //msg
                        lvi.SubItems.Add(tmpStr);
                        lvIn.Items.Add(lvi);
                    }
                    dr.Close();
                }

                sqlConn.Close(); //we close the SQL connection
            }
            catch (Exception)
            {

            }

            CloseConnection();
        }
    }
}
